/*
*******************************************************************************
*
* File:		pxrtbeh.h
* Description:  Function declarations for requester target behavior
* Author: 	Henrik Liebau
* Created: 	05 Apr 2000, 09:24:05
* Modified:     Wed Jun  7 18:22:35 2000 by Henrik Liebau, BVS R&D
* Language:	C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer 
* Status: 	
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxrtbeh_H__
#define __pxrtbeh_H__

/* include type definitions, if not already done */
#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

/* include type definitions, if not already done */
#ifndef __pxbehdef_H__
#include <pxbehdef.h>
#endif /* defined __pxbehdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 * BestXPprRTDefaultSet 
 * CLI abbrev.: pprrtdefaultset
 *
 * Set all settings concerning the requester target to default values 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTDefaultSet (	       /* @pprrtdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprRTBehPermDefaultSet 
 * CLI abbrev.: pprrtbehpermdefaultset
 *
 * Set PPR Ri Behavior perm settings to defaults 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTBehPermDefaultSet (    /* @pprrtbehpermdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprRTBehPermSet 
 * CLI abbrev.: pprrtbehpermset prop=<permprop> val = <value>
 *
 * Set PPR Behavior requester target settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTBehPermSet (	       /* @pprrtbehpermset */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 value				       /* @val */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRTBehPermGet 
 * CLI abbrev.: pprrtbehpermget prop=<permprop> val = <value>
 *
 * Get PPR Behavior requester target settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTBehPermGet (	       /* @pprrtbehpermget */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%08lx\\h" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRTBehListDefaultSet 
 * CLI abbrev.: pprrtbehlistdefaultset beh = <behavior>
 *
 * set variation list for requester target behaviors to default 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTBehListDefaultSet (    /* @pprrtbehlistdefaultset */
  bx_handletype handle,
  bx_rtbehtype behavior				       /* @beh */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRTBehListSet 
 * CLI abbrev.: pprrtbehlistset beh = <behavior> list = <list>
 *
 * set variation list for requester target behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTBehListSet (	       /* @pprrtbehlistset */
  bx_handletype handle,
  bx_rtbehtype behavior,			       /* @beh */
  bxppr_listtype list				       /* @list */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRTBehListGet 
 * CLI abbrev.: pprrtbehlistget beh = <behavior> list = <list>
 *
 * get variation list for requester target behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTBehListGet (	       /* @pprrtbehlistget */
  bx_handletype handle,
  bx_rtbehtype behavior,			       /* @beh */
  bxppr_listtype * pList			       /* #RETURN "%s" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRTBehResultGet 
 * CLI abbrev.: pprrtbehresultget prop = <resultprop>
 *
 * get permutation result for selected resultprop parameter 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRTBehResultGet (	       /* @pprrtbehresultget */
  bx_handletype handle,
  bxppr_behresulttype resultprop,		       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%lu" */
 );

/*****************************************************************************
 * functions used internally
 *****************************************************************************/

#ifdef PPRX_EXPORTS

/*---------------------------------------------------------------------------*
 * bx_errtype PprRTBehProg ( bx_handletype handle,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprRTBehProg ( bx_handletype handle,
			  bxppr_vardatatype * varData,
			  bxppr_behresultdatatype * behResult );

/*---------------------------------------------------------------------------*
 * bx_errtype PprRTBehResultCompute ( bxppr_behresultdatatype * behResult )
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprRTBehResultCompute ( bxppr_vardatatype * varData,
				   bxppr_behresultdatatype * behResult );

#endif /* defined PPRX_EXPORTS */


#ifdef __cplusplus
}
#endif


#endif /* defined __pxrtbeh_H__ */
